---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 10
  claims_with_evidence: 8
  claims_without_evidence: 2
confidence_derived: 0.80
---

# 根拠レポート：22-Route Groups

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.80**
  - 根拠あり：8 / 10、根拠なし：2
- 優先レビュー（高）
  1. **C-08**：レイアウト競合の具体的なエラー処理の実装根拠不足
  2. **C-10**：ルートレイアウト複数定義の具体的な制約条件の根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/shared/lib/router/utils/app-paths.ts` - normalizeAppPath実装
- E-02: `packages/next/src/build/validate-app-paths.ts` - パス重複バリデーション
- E-03: `packages/next/src/build/validate-app-paths.test.ts` - バリデーションテスト
- E-04: `packages/next/src/build/webpack/loaders/next-app-loader/index.ts` - appローダー
- E-05: `packages/next/src/server/lib/router-utils/filesystem.ts` - ファイルシステムルーター
- E-06: `packages/next/src/lib/verify-root-layout.ts` - ルートレイアウト検証
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | (folderName)形式のフォルダ名がURLパスに含まれない | E-01 | ○ |
| C-02 | normalizeAppPathで括弧付きセグメントが除去される | E-01 | ○ |
| C-03 | 異なるRoute Groupが同一URLパスを生成するとビルドエラー | E-02, E-03 | ○ |
| C-04 | Route Group内のlayout.tsxは互いに独立 | E-04 | ○ |
| C-05 | ファイルシステムスキャン時にRoute Groupが検出される | E-04, E-05 | ○ |
| C-06 | パス正規化はビルド時に解決される | E-01, E-02 | ○ |
| C-07 | ランタイムパフォーマンスへの影響なし | E-01 (文字列操作のみ) | ○ |
| C-08 | 同一パスに複数Route Groupからレイアウト競合時のエラー処理 | **根拠なし** | △ |
| C-09 | 並列ルートやインターセプトルートと組み合わせ可能 | E-04 | ○ |
| C-10 | 各Route Groupに独自のルートレイアウトを持てるが最上位は1つ | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- レイアウト競合時の具体的なエラーメッセージとハンドリングの実装箇所が未確認
  - 候補：`packages/next/src/build/index.ts` / `packages/next/src/lib/verify-root-layout.ts`
- 複数Route Groupでの独立ルートレイアウトの正確な動作条件が未確認
  - 候補：`packages/next/src/lib/verify-root-layout.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Route Groupのパス正規化はソースコードで直接確認済み
- 0: 低リスク - パス重複バリデーションはテストファイルで確認済み
- 1: 中リスク - レイアウト競合時のエラーハンドリング詳細の根拠要確認
- 1: 中リスク - 複数ルートレイアウトの制約条件の根拠要確認

## 6) レビュアーチェックリスト（最小）
- [ ] normalizeAppPathの括弧セグメント除去ロジックが正しいか確認
- [ ] validateAppPathsのバリデーションロジックが正確か確認
- [ ] レイアウト競合時のエラー処理の実装を確認
- [ ] verify-root-layoutの複数ルートレイアウト制約を確認
